@extends('layouts.admin')

@section('title', 'Edit News Article')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Edit News Article</h1>
            <a href="{{ route('admin.news.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to News
            </a>
        </div>
        <p>Edit an existing news article</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>News Article Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.news.update', $news) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" name="title" id="title" class="form-control @error('title') has-error @enderror" value="{{ old('title', $news->title) }}" required>
                    @error('title')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="short_description">Short Description</label>
                    <textarea name="short_description" id="short_description" class="form-control @error('short_description') has-error @enderror" rows="3" required>{{ old('short_description', $news->short_description) }}</textarea>
                    @error('short_description')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">A brief description (max 500 characters) that will be shown in news listings</div>
                </div>

                <div class="form-group">
                    <label for="image">Featured Image</label>
                    <div class="file-upload-wrapper">
                        <input type="file" name="image" id="image" class="file-upload-input @error('image') has-error @enderror" accept="image/*">
                        <label for="image" class="file-upload-label">
                            <i class="fas fa-cloud-upload-alt file-upload-icon"></i>
                            <span>Choose a new image file</span>
                        </label>
                        <div class="file-upload-preview" id="imagePreview">
                            @if($news->image)
                                <div class="current-file">
                                    <img src="{{ Storage::url($news->image) }}" class="file-preview" alt="{{ $news->title }}">
                                    <span class="file-name">Current Image</span>
                                </div>
                            @endif
                        </div>
                    </div>
                    @error('image')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Recommended size: 1200 x 630 pixels. Leave empty to keep current image.</div>
                </div>

                <div class="form-group">
                    <label for="content">Content</label>
                    @component('components.bbcode-editor')
                        @slot('name', 'content')
                        @slot('content', old('content', $news->content))
                        @slot('placeholder', 'Enter the news article content here...')
                        @slot('height', '300px')
                    @endcomponent
                    @error('content')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <div class="d-flex">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update News Article
                        </button>
                        <a href="{{ route('admin.news.show', $news) }}" class="btn btn-secondary ml-sm">
                            <i class="fas fa-eye"></i> View Article
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Image preview functionality
            const imageInput = document.getElementById('image');
            const imagePreview = document.getElementById('imagePreview');
            const currentPreview = imagePreview.querySelector('.current-file');
            
            imageInput.addEventListener('change', function() {
                // Remove the "new-file" div if it exists
                const newFilePreview = imagePreview.querySelector('.new-file');
                if (newFilePreview) {
                    imagePreview.removeChild(newFilePreview);
                }
                
                if (this.files && this.files[0]) {
                    if (currentPreview) {
                        currentPreview.style.opacity = '0.5';
                    }
                    
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        const previewContainer = document.createElement('div');
                        previewContainer.className = 'new-file';
                        
                        const previewImage = document.createElement('img');
                        previewImage.className = 'file-preview';
                        previewImage.src = e.target.result;
                        
                        const fileName = document.createElement('span');
                        fileName.className = 'file-name';
                        fileName.textContent = 'New Image';
                        
                        previewContainer.appendChild(previewImage);
                        previewContainer.appendChild(fileName);
                        imagePreview.appendChild(previewContainer);
                    }
                    
                    reader.readAsDataURL(this.files[0]);
                } else {
                    if (currentPreview) {
                        currentPreview.style.opacity = '1';
                    }
                }
            });
        });
    </script>
@endpush